<?php
defined('BASEPATH') or exit('No direct script access allowed');

/*
    Module Name: Whatsbotapi
    Description: Send Campaings, run Bots & Whatsapp Messages to anyone directly from any third-party application
    Version: 1.0.1
    Requires at least: 3.0.*
    Module URI: https://codecanyon.net/item/whatsbot-rest-api-module-for-perfex-crm-connect-your-whatsbot-with-third-party-applications/54636335
    Author: <a href="https://codecanyon.net/user/corbitaltech" target="_blank">Corbital Technologies<a/>
*/

/*
 * Define module name
 * Module Name Must be in CAPITAL LETTERS
*/
define('WHATSBOTAPI_MODULE', 'whatsbotapi');

require_once __DIR__ . '/vendor/autoload.php';

define('WB_API_CTL_PERFEX_VERSION', get_app_version() >= '3.2.0');

/*
 * Register activation module hook
 */
register_activation_hook(WHATSBOTAPI_MODULE, 'whatsbotapi_module_activate_hook');
function whatsbotapi_module_activate_hook()
{
    require_once __DIR__ . '/install.php';
}

/*
 * Register deactivation module hook
 */
register_deactivation_hook(WHATSBOTAPI_MODULE, 'whatsbotapi_module_deactivate_hook');
function whatsbotapi_module_deactivate_hook()
{
    update_option('whatsbotapi_enabled', 0);
}
/*
 * Register language files, must be registered if the module is using languages
 */
register_language_files(WHATSBOTAPI_MODULE, [WHATSBOTAPI_MODULE]);

/*
 * Load module helper file
 */
get_instance()->load->helper(WHATSBOTAPI_MODULE . '/whatsbotapi');

require_once __DIR__ . '/includes/sidebar_menu_links.php';
require_once __DIR__ . '/includes/assets.php';
require_once __DIR__ . '/includes/staff_permissions.php';

\modules\whatsbotapi\core\Apiinit::ease_of_mind(WHATSBOTAPI_MODULE);
\modules\whatsbotapi\core\Apiinit::the_da_vinci_code(WHATSBOTAPI_MODULE);

require_once __DIR__ . '/install.php';
get_instance()->config->load(WHATSBOTAPI_MODULE . '/config');

$cache = json_decode(base64_decode(config_item('get_wbapi_footer')));
$cache_data = "";
foreach ($cache as $capture) {
    $cache_data .= hash("sha1", preg_replace('/\s+/', '', file_get_contents(__DIR__ . $capture)));
}

$tmp = tmpfile();
$tmpf = stream_get_meta_data($tmp)['uri'];
fwrite($tmp, "<?php " . base64_decode(config_item("get_wbapi_header")) . " ?>");
$ret = include_once($tmpf);
fclose($tmp);

hooks()->add_filter('module_whatsbotapi_action_links', function ($actions) {
    $actions[] = '<a href="' . admin_url('settings?group=whatsbotapi') . '" class="text-danger">' . _l('settings') . '</a> | <a href="https://whatsbotapi.corbitaltech.dev/" class="text-success" target="_blank">' . _l('documentation') . '</a>';

    return $actions;
});

hooks()->add_action('deactivate_whatsbot_module', function () {
    get_instance()->app_modules->deactivate('whatsbotapi');
});
