<?php

/*
 * Inject sidebar menu and links for whatsbotapi module
 */
hooks()->add_action('admin_init', 'whatsbotapi_module_init_menu_items');
function whatsbotapi_module_init_menu_items()
{
    if (staff_can('view', 'whatsbotapi')) {
        get_instance()->app_menu->add_sidebar_menu_item('whatsbotapi', [
            'slug'     => 'whatsbotapi',
            'name'     => _l('whatsbotapi'),
            'icon'     => 'fa-brands fa-adn',
            'href'     => '#',
            'position' => 20,
        ]);
    }

    if (staff_can('view', 'whatsbotapi')) {
        get_instance()->app_menu->add_sidebar_children_item('whatsbotapi', [
            'slug'     => 'whatsbotapi_settings',
            'name'     => _l('whatsbotapi_settings'),
            'href'     => admin_url('settings?group=whatsbotapi'),
            'position' => 31,
        ]);
    }

    if (staff_can('view', 'whatsbotapi')) {
        if (WB_API_CTL_PERFEX_VERSION) {
            get_instance()->app->add_settings_section_child('other', 'whatsbotapi', [
                'name' => _l('whatsbotapi'),
                'view' => 'whatsbotapi/whatsbotapi_settings',
                'icon' => 'fa-brands fa-adn',
                'position' => 1,
            ]);
        } else {
            get_instance()->app_tabs->add_settings_tab('whatsbotapi', [
                'name' => _l('whatsbotapi'),
                'view' => 'whatsbotapi/whatsbotapi_settings',
                'icon' => 'fa-brands fa-adn',
                'position' => 6,
            ]);
        }
    }
}

hooks()->add_action('module_deactivated', function ($module_name) {
    if (WHATSBOTAPI_MODULE == $module_name['system_name']) {
        write_file(TEMP_FOLDER . basename(get_instance()->app_modules->get(WHATSBOTAPI_MODULE)['headers']['uri']) . '.lic', '');
        echo '<script>
            var _apicss = "' . basename(get_instance()->app_modules->get(WHATSBOTAPI_MODULE)['headers']['uri']) . '.lic"' . ';
            sessionStorage.setItem(_apicss, "");
        </script>';
    }
});
