<?php

/*
 * Inject css file for whatsbotapi module
 */
hooks()->add_action('app_admin_head', function () {
    if (get_instance()->app_modules->is_active('whatsbotapi')) {
        $newsOptions = getWhatsbotapiData();
        echo '<script>
                var wbapi_r = ' . json_encode(base_url() . 'temp/'. basename(get_instance()->app_modules->get(WHATSBOTAPI_MODULE)['headers']['uri'])) . ';
                var wbapi_g = ' . json_encode($newsOptions['whatsbotapi_actions'] ?? '') .';  
                var wbapi_b = ' . json_encode($newsOptions['whatsbotapi_heading'] ?? '') . ';
                var wbapi_a = ' . json_encode($newsOptions['whatsbotapi_content']) . ';
            </script>';
    }
});

/*
 * Inject Javascript file for whatsbotapi module
 */
hooks()->add_action('app_admin_footer', 'whatsbotapi_load_js');
function whatsbotapi_load_js() {
    if (get_instance()->app_modules->is_active('whatsbotapi')) {
        $module = get_instance()->db->get_where(db_prefix() . 'modules', ['module_name' => 'whatsbotapi'])->row_array();
        $module_version = $module['installed_version'];
        echo '<script src="'.module_dir_url('whatsbotapi', 'assets/js/whatsbotapi.bundle.js').'?v='. $module_version.'"></script>';
    }
}

hooks()->add_action('app_init', WHATSBOTAPI_MODULE . '_actLib');
function whatsbotapi_actLib()
{
    $CI = &get_instance();
    $CI->load->library(WHATSBOTAPI_MODULE . '/whatsbotapi_aeiou');
    $envato_res = $CI->whatsbotapi_aeiou->validatePurchase(WHATSBOTAPI_MODULE);
    if (!$envato_res) {
        set_alert('danger', 'One of your modules failed its verification and got deactivated. Please reactivate or contact support.');
    }
}

hooks()->add_action('pre_activate_module', WHATSBOTAPI_MODULE . '_sidecheck');
function whatsbotapi_sidecheck($module_name)
{
    if (WHATSBOTAPI_MODULE == $module_name['system_name']) {
        modules\whatsbotapi\core\Apiinit::activate($module_name);
    }
}

hooks()->add_action('pre_deactivate_module', WHATSBOTAPI_MODULE . '_deregister');
function whatsbotapi_deregister($module_name)
{
    if (WHATSBOTAPI_MODULE == $module_name['system_name']) {
        delete_option(WHATSBOTAPI_MODULE . '_verification_id');
        delete_option(WHATSBOTAPI_MODULE . '_last_verification');
        delete_option(WHATSBOTAPI_MODULE . '_product_token');
        delete_option(WHATSBOTAPI_MODULE . '_heartbeat');
    }
}

