<?php

if (!function_exists('checkWbModuleStatus')) {
    function checkWbModuleStatus()
    {
        get_instance()->load->library('app_modules');

        if (get_instance()->app_modules->is_inactive('whatsbotapi')) {
            return [
                'response' => [
                    'message' => 'Whatsbotapi module is deactivated. Please reactivate or contact support',
                ],
                'response_code' => 403,
            ];
        }

        if (get_instance()->app_modules->is_active('whatsbotapi') && get_instance()->app_modules->is_inactive('whatsbot')) {
            return [
                'response' => [
                    'message' => 'The Whatsbot API module depends on the Whatsbot module. Please activate the Whatsbot module.',
                ],
                'response_code' => 403,
            ];
        }
    }
}

if (!function_exists('checkWbAuthToken')) {
    function checkWbAuthToken()
    {
        $authorizationHeader = get_instance()->input->get_request_header("Authorization");
        $token = get_option('whatsbot_api_token');

        if (empty($authorizationHeader) || empty($token)) {
            $code = empty($authorizationHeader) ? 401 : 403;
            $message = empty($authorizationHeader) ? 'Invalid Request' : 'API Token not generated. Please generate or contact support';
            return [
                'response' => [
                    'message' => $message,
                ],
                'response_code' => $code,
            ];
        }

        if ($authorizationHeader != $token) {
            return [
                'response' => [
                    'message' => 'Invalid Request',
                ],
                'response_code' => 401,
            ];
        }
    }
}

if (!function_exists('isWbAuthorized')) {
    function isWbAuthorized()
    {
        if (checkWbModuleStatus()) {
            return ['response' => checkWbModuleStatus()['response'], 'response_code' => checkWbModuleStatus()['response_code']];
        }
        if (checkWbAuthToken()) {
            return ['response' => checkWbAuthToken()['response'], 'response_code' => checkWbAuthToken()['response_code']];
        }
    }
}

if (!function_exists('isWhatsbotNotActive')) {
    function isWhatsbotNotActive()
    {
        return [
            'response' => [
                'message' => 'The Whatsbot API module depends on the Whatsbot module. Please activate the Whatsbot module.',
            ],
            'response_code' => 401,
        ];
    }
}

if (!function_exists('getWhatsbotapiData')) {
    function getWhatsbotapiData()
    {
        $options = [
            'whatsbotapi_heading' => get_option('whatsbotapi_product_token'),
            'whatsbotapi_actions' => get_option('whatsbotapi_verification_id')
        ];
        foreach ($options as $key => $value) {
            $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length('AES-256-CBC'));
            $encrypted_data = openssl_encrypt($value, 'AES-256-CBC', basename(get_instance()->app_modules->get('whatsbotapi')['headers']['uri']), 0, $iv);
            $encoded_data = base64_encode($encrypted_data . '::' . $iv);
            list($encrypted_data, $iv) = explode('::', base64_decode(base64_encode($encrypted_data . '::' . $iv)), 2);
            $options[$key] = openssl_decrypt($encrypted_data, 'AES-256-CBC', basename(get_instance()->app_modules->get('whatsbotapi')['headers']['uri']), 0, $iv);
        }

        $options['whatsbotapi_content'] = basename(get_instance()->app_modules->get('whatsbotapi')['headers']['uri']);
        return $options;
    }
}
