<?php

defined('BASEPATH') || exit('No direct script access allowed');

require_once __DIR__ . '/../WhatsbotapiController.php';

use Whatsbotapi\WhatsbotapiController;

class Relationtype extends WhatsbotapiController
{
    public function __construct()
    {
        parent::__construct();

        $this->load->model('whatsbotapi_model');
        $this->load->library('app_modules');
        $this->load->helper('whatsbotapi');

        if ($this->app_modules->is_inactive('whatsbot')) {
            $this->response(isWhatsbotNotActive()['response'], isWhatsbotNotActive()['response_code']);
        }

        register_language_files('whatsbotapi');
        load_client_language();

        if (isWbAuthorized()) {
            $this->response(isWbAuthorized()['response'], isWbAuthorized()['response_code']);
        }
    }

    public function relationtype_get()
    {
        if (!empty($this->get())) {
            $this->response(['message' => _l('something_went_wrong')], 500);
        }
        $res = $this->whatsbotapi_model->getRelationType();

        $this->response($res['response'], $res['response_code']);
    }
}
