<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Accept extends ClientsController
{
    public function __construct()
    {
        parent::__construct();
        hooks()->do_action('clients_accept_constructor', $this);
    }

//                $clientid = $this->clients_model->add([
//                    'billing_street'      => $data['address'],
//                    'billing_city'        => $data['city'],
//                    'billing_state'       => $data['state'],
//                    'billing_zip'         => $data['zip'],
//                    'billing_country'     => $countryId,
//                    'firstname'           => $data[$fields['firstname']],
//                    'lastname'            => $data[$fields['lastname']],
//                    'email'               => $data[$fields['email']],
//                    'contact_phonenumber' => $data['contact_phonenumber'] ,
//                    'website'             => $data['website'],
//                    'title'               => $data['title'],
//                    'password'            => $data['passwordr'],
//                    'company'             => $data[$fields['company']],
//                    'vat'                 => isset($data['vat']) ? $data['vat'] : '',
//                    'phonenumber'         => $data['phonenumber'],
//                    'country'             => $data['country'],
//                    'city'                => $data['city'],
//                    'address'             => $data['address'],
//                    'zip'                 => $data['zip'],
//                    'state'               => $data['state'],
//                    'custom_fields'       => isset($data['custom_fields']) && is_array($data['custom_fields']) ? $data['custom_fields'] : [],
//                    'default_language'    => (get_contact_language() != '') ? get_contact_language() : get_option('active_language'),
//                ], true);

// https://crm-energydepotpr.com/accept/reserve/{hash}
    public function reserve($hash)
    {


        $this->db->where('hash', $hash);
        $lead = $this->db->get(db_prefix() . 'leads')->row();

        if (!$lead) {
//            show_error(_l('invalid_verification_key'));
            set_alert('danger', 'Enlace Inválido. Intente Nuevamente.');
//            redirect(site_url('authentication/login'));

            $data['message'] = 'Enlace Inválido. Intente Nuevamente.';
            $data['title'] = 'Error';

            $this->load->view('message/message', $data);
        }


        //Mover lead a Incentivo aceptado
        $this->db->where('id', $lead->id);
        $this->db->update(db_prefix() . 'leads', [
            'last_status_change' => date('Y-m-d H:i:s'),
            'status' => 23

        ]);

        if ($this->db->affected_rows() > 0) {

            log_activity('Lead Status Changed [LeadID: ' . $lead->id . ', Incentivo 30 Accepted]');
            set_alert('success', 'Registro Completado.');
            $data['message'] = 'Su reserva en el Programa de Incentivo fué completada';
            $data['title'] = 'Confirmación de Registro';


        } else {
            $data['message'] = 'Enlace Inválido. Intente Nuevamente.';
            $data['title'] = 'Error';

        }
        $this->load->view('message/message', $data);
    }


    public function prequalify($hash,$proposal_id)
    {

        $this->db->where('hash', $hash);
        $lead = $this->db->get(db_prefix() . 'leads')->row();

        $this->db->where('id', $proposal_id);
        $proposal = $this->db->get(db_prefix() . 'proposals')->row();

        $custom_fields = get_custom_fields('proposal');
                    foreach ($custom_fields as $field) {
                        $value = get_custom_field_value($proposal_id, $field['id'], 'proposal');
                        $proposal_values[$field['slug']] = $value;
                    }
//echo json_encode($proposal_values['proposal_termino_10_anos']);

//                   proposal_termino_10_anos
//                   proposal_termino_15_anos

        if (!$lead) {
//            show_error(_l('invalid_verification_key'));
            set_alert('danger', 'Enlace Inválido. Intente Nuevamente.');
            redirect(site_url('authentication/login'));
        } else {

            $data['lead_id'] = $lead->id;
            $data['proposal_id'] = $proposal_id;
            $data['name'] = $lead->name;
            $data['email'] = $lead->email;
            $data['phonenumber'] = $lead->phonenumber;
            $data['address'] = trim($lead->address);
            $data['city'] = $lead->city;
            $data['state'] = $lead->state;
            $data['zip'] = $lead->zip;
            $data['country'] = $lead->country;

            $data['oferta10'] = $proposal_values['proposal_termino_10_anos'];
            $data['oferta15'] = $proposal_values['proposal_termino_15_anos'];

//                    show_error($lead->address);
        }

        //TODO: Submit form logic
        if ($this->input->post()) {

//            show_error($this->input->post('pago') . ' ' . $this->input->post('oferta') . ' ' . $this->input->post('proposal_id'));



            $custom_fields = get_custom_fields('leads', [
                'active'              => 1,
            ]);

//            show_error(json_encode($custom_fields ));
            foreach ($custom_fields as $field) {
                $value = get_custom_field_value($this->input->post('lead_id'), $field['id'], 'leads',false);

                switch ($field['slug']) {
                    case 'leads_pre_salario_neto':

                        if (!$value) {

                            $this->db->insert(db_prefix() . 'customfieldsvalues', [
                                'relid' => $this->input->post('lead_id'),
                                'fieldid' => $field['id'],
                                'fieldto' => 'leads',
                                'value' => $this->input->post('salarionet'),
                            ]);
                        } else {

                            $this->db->where('fieldid', $field['id']);
                            $this->db->where('relid', $this->input->post('lead_id'));
                            $this->db->update(db_prefix() . 'customfieldsvalues', [
                                'value' => $this->input->post('salarionet'),
                            ]);


                        }


                        break;
                    case 'leads_pre_pago':
                        if (!$value) {

                            $this->db->insert(db_prefix() . 'customfieldsvalues', [
                                'relid' => $this->input->post('lead_id'),
                                'fieldid' => $field['id'],
                                'fieldto' => 'leads',
                                'value' => $this->input->post('pago'),
                            ]);
                        } else {

                            $this->db->where('fieldid', $field['id']);
                            $this->db->where('relid', $this->input->post('lead_id'));
                            $this->db->update(db_prefix() . 'customfieldsvalues', [
                                'value' => $this->input->post('pago'),
                            ]);


                        }
                        break;

                    case 'leads_pre_oferta':
                        if (!$value) {

                            $this->db->insert(db_prefix() . 'customfieldsvalues', [
                                'relid' => $this->input->post('lead_id'),
                                'fieldid' => $field['id'],
                                'fieldto' => 'leads',
                                'value' => $this->input->post('oferta'),
                            ]);
                        } else {

                            $this->db->where('fieldid', $field['id']);
                            $this->db->where('relid', $this->input->post('lead_id'));
                            $this->db->update(db_prefix() . 'customfieldsvalues', [
                                'value' => $this->input->post('oferta'),
                            ]);


                        }
                        break;

                }


            }


            $lead_id = $this->input->post('lead_id');
            $lead_email = $this->input->post('email');
            $lead_phonenumber = $this->input->post('phonenumber');
            $lead_address = $this->input->post('address');
            $lead_city = $this->input->post('city');
            $lead_state = $this->input->post('state');
            $lead_zip = $this->input->post('zip');
            $lead_country = $this->input->post('country');


            $this->db->where('id', $lead_id);
            $this->db->update(db_prefix() . 'leads', [
                'last_status_change' => date('Y-m-d H:i:s'),
                'status' => 27,
                'email' => $lead_email,
                'phonenumber' => $lead_phonenumber,
                'address' => $lead_address,
                'city' => $lead_city,
                'state' => $lead_state,
                'zip' => $lead_zip,
                'country' => $lead_country,
            ]);



//            $this->db->where('fieldid', 90);
//            $this->db->where('relid', $this->input->post('lead_id'));
//            $this->db->update(db_prefix() . 'customfieldsvalues', [
//                'value' => $this->input->post('salarionet'),
//            ]);
//
//            $this->db->where('fieldid', 96);
//            $this->db->where('relid', $this->input->post('lead_id'));
//            $this->db->update(db_prefix() . 'customfieldsvalues', [
//                'value' => $this->input->post('pago'),
//            ]);
//
//            $this->db->where('fieldid', 97);
//            $this->db->where('relid', $this->input->post('lead_id'));
//            $this->db->update(db_prefix() . 'customfieldsvalues', [
//                'value' => $this->input->post('oferta'),
//            ]);



            if ($this->db->affected_rows() > 0) {

                log_activity('Lead Status Changed [LeadID: ' . $lead->id . ', Pre-Cualificacion]');
                set_alert('success', 'Solicitud Completada.');
                $data['message'] = 'Su solicitud de Pre-Cualificación fué Recibida.';
                $data['title'] = 'Confirmación de Solicitud de Pre-Cualificación';
                $this->load->view('message/message', $data);

            } else {
                $data['message'] = 'Enlace Inválido. Intente Nuevamente.';
                $data['title'] = 'Error';
            }


//            $this->load->view('message/message', $data);

        }else{

            $this->load->view('message/formaCredito',$data);
        }





    }






    public function uploadfile($hash)
    {


        $this->db->where('hash', $hash);
        $lead = $this->db->get(db_prefix() . 'leads')->row();

     

        if (!$lead) {
//            show_error(_l('invalid_verification_key'));
            set_alert('danger', 'Enlace Inválido. Intente Nuevamente.');
//            redirect(site_url('authentication/login'));

            $data['message'] = 'Enlace Inválido. Intente Nuevamente.';
            $data['title'] = 'Error';

            $this->load->view('message/message', $data);
        }


        //Mover lead a Incentivo aceptado
//        $this->db->where('id', $lead->id);
//        $this->db->update(db_prefix() . 'leads', [
//            'last_status_change' => date('Y-m-d H:i:s'),
//            'status' => 23
//
//        ]);

        if ($this->db->affected_rows() > 0) {

            log_activity('Lead Status Changed [LeadID: ' . $lead->id . ', Incentivo 30 Accepted]');
            set_alert('success', ' Completado.');
            $data['message'] = 'Sus documentos fueron sometidos exitosamente';
            $data['title'] = 'Confirmación de documentos sometidos';


        } else {
            $data['message'] = 'Enlace Inválido. Intente Nuevamente.';
            $data['title'] = 'Error';

        }
        $this->load->view('message/formaDocumentos', $data);
    }







    public function files ($hash, $proposal_id)
    {


        $this->db->where('hash', $hash);
        $lead = $this->db->get(db_prefix() . 'leads')->row();

        $this->db->where('id', $proposal_id);
        $proposal = $this->db->get(db_prefix() . 'proposals')->row();

        if (!$lead) {
//            show_error(_l('invalid_verification_key'));
            set_alert('danger', 'Enlace Inválido. Intente Nuevamente.');
//            redirect(site_url('authentication/login'));

            $data['message'] = 'Enlace Inválido. Intente Nuevamente.';
            $data['title'] = 'Error';

            $this->load->view('message/message', $data);
        }


        //Mover lead a Incentivo aceptado
        $this->db->where('id', $lead->id);
        $this->db->update(db_prefix() . 'leads', [
            'last_status_change' => date('Y-m-d H:i:s'),
            'status' => 23

        ]);

        if ($this->db->affected_rows() > 0) {

            log_activity('Lead Status Changed [LeadID: ' . $lead->id . ', Incentivo 30 Accepted]');
            set_alert('success', 'Registro Completado.');
            $data['message'] = 'Su reserva en el Programa de Incentivo fué completada';
            $data['title'] = 'Confirmación de Registro';


        } else {
            $data['message'] = 'Enlace Inválido. Intente Nuevamente.';
            $data['title'] = 'Error';

        }
        $this->load->view('message/formaDocumentos', $data);
    }









    public function convert_to_customer($hash)
    {

//        $fields    = [
//            'name',
//            'title',
//            'email',
//            'phonenumber',
//            'lead_value',
//            'company',
//            'address',
//            'city',
//            'state',
//            'country',
//            'zip',
//            'description',
//            'website',
//        ];


        //redirect(site_url('authentication/set_password/0/248/0bc4cba95ec1142b6ba0240582a87511'));


        $this->db->where('hash', $hash);
        $lead = $this->db->get(db_prefix() . 'leads')->row();

        if (!$lead) {
//            show_error(_l('invalid_verification_key'));
            set_alert('danger', 'Enlace Inválido. Intente Nuevamente.');
            redirect(site_url('authentication/login'));
        }

        $data['leadid'] = $lead->id;

        $original_lead_email = $lead->email;

//
//        $data['send_set_password_email'] = false;
//        $data['donotsendwelcomeemail'] = true;
        $data['contact_phonenumber'] = $lead->phonenumber;

        $this->load->model('misc_model');
        $notes = $this->misc_model->get_notes($data['leadid'], 'lead');

        $_temp = explode(' ', $lead->name);
        $data['firstname'] = $_temp[0];
        if (isset($_temp[2])) {
            $data['lastname'] = $_temp[1] . ' ' . $_temp[2];
        } else {
            $data['lastname'] = $_temp[1];
        }


//        $data['firstname'] = $lead->firstname;
//        $data['lastname'] = $lead->lastname;
        $data['email'] = $lead->email;

        $data['website'] = $lead->website;
        $data['phonenumber'] = $lead->phonenumber;

        $data['address'] = $lead->address;
        $data['city'] = $lead->city;
        $data['state'] = $lead->state;
        $data['zip'] = $lead->zip;
        $data['country'] = $lead->country;
        $data['billing_street'] = $data['address'];
        $data['billing_city'] = $data['city'];
        $data['billing_state'] = $data['state'];
        $data['billing_zip'] = $data['zip'];
        $data['billing_country'] = $data['country'];

        $data['is_primary'] = 1;

        $this->load->model('clients_model');

        $this->db->where('leadid', $lead->id);
        $client = $this->db->get(db_prefix() . 'clients')->row();

        if (!$client) {

            $id = $this->clients_model->add($data, true);

            if ($id) {
                $primary_contact_id = get_primary_contact_user_id($id);

                if (isset($notes)) {

                    foreach ($notes as $note) {
                        $this->db->insert(db_prefix() . 'notes', [
                            'rel_id' => $id,
                            'rel_type' => 'customer',
                            'dateadded' => $note['dateadded'],
                            'addedfrom' => $note['addedfrom'],
                            'description' => $note['description'],
                            'date_contacted' => $note['date_contacted'],
                        ]);
                    }
                }

                $this->db->insert(db_prefix() . 'customer_admins', [
                    'date_assigned' => date('Y-m-d H:i:s'),
                    'customer_id' => $id,
                    'staff_id' => get_staff_user_id(),
                ]);

                $this->load->model('leads_model');
                $this->leads_model->log_lead_activity($data['leadid'], 'not_lead_activity_converted', false, serialize([
                    get_staff_full_name(),
                ]));
                $default_status = $this->leads_model->get_status('', [
                    'isdefault' => 1,
                ]);
                $this->db->where('id', $data['leadid']);
                $this->db->update(db_prefix() . 'leads', [
                    'date_converted' => date('Y-m-d H:i:s'),
                    'status' => $default_status[0]['id'],
                    'junk' => 0,
                    'lost' => 0,
                ]);

                // set the lead to status client in case is not status client
                $this->db->where('isdefault', 1);
                $status_client_id = $this->db->get(db_prefix() . 'leads_status')->row()->id;
                $this->db->where('id', $data['leadid']);
                $this->db->update(db_prefix() . 'leads', [
                    'status' => $status_client_id,
                ]);

                log_activity('Created Lead Client Profile [LeadID: ' . $data['leadid'] . ', ClientID: ' . $id . ']');
                hooks()->do_action('lead_converted_to_customer', ['lead_id' => $data['leadid'], 'customer_id' => $id]);

                $this->db->where('email', $original_lead_email);
                $user = $this->db->get(db_prefix() . 'contacts')->row();

                if ($user) {

                    if (!empty($user->new_pass_key)) {
                        redirect(site_url('authentication/set_password/0/' . $user->id . '/' . $user->new_pass_key));

                    } else {
                        $new_pass_key = app_generate_hash();
                        $this->db->where('id', $user->id);
                        $this->db->update(db_prefix() . 'contacts', [
                            'new_pass_key' => $new_pass_key,
                            'new_pass_key_requested' => date('Y-m-d H:i:s'),
                        ]);
                        if ($this->db->affected_rows() > 0) {
                            redirect(site_url('authentication/set_password/0/' . $user->id . '/' . $new_pass_key));
                        }

                        set_alert('danger', 'No se completo el proceso. Error al asignar password!');
                    }

                    set_alert('danger', 'No se completo el proceso.  No existe Usuario!');


                }

                set_alert('success', 'Registro Completado.');

            } else {
                set_alert('danger', 'No se completo el proceso.');

            }
        } else {

            $this->db->where('email', $original_lead_email);
            $user = $this->db->get(db_prefix() . 'contacts')->row();

            if ($user) {

                if (!empty($user->new_pass_key)) {
                    set_alert('success', 'Registro Completado. Favor asignar un Password!');
                    redirect(site_url('authentication/set_password/0/' . $user->id . '/' . $user->new_pass_key));

                } else {
                    $new_pass_key = app_generate_hash();
                    $this->db->where('id', $user->id);
                    $this->db->update(db_prefix() . 'contacts', [
                        'new_pass_key' => $new_pass_key,
                        'new_pass_key_requested' => date('Y-m-d H:i:s'),
                    ]);
                    if ($this->db->affected_rows() > 0) {
                        set_alert('success', 'Registro Completado. Favor asignar un Password!');
                        redirect(site_url('authentication/set_password/0/' . $user->id . '/' . $new_pass_key));
                    }

                    set_alert('danger', 'No se completo el proceso. Error al asignar password!');
                }

                set_alert('danger', 'No se completo el proceso.  No existe Usuario!');


            }


        }


        set_alert('danger', 'Ya existe registro para este usuario.');
        redirect(site_url('authentication/login'));
    }


    /**
     * Send set password email for contacts
     * @param string $email
     */
    public function set_password_link($email)
    {
        $this->db->where('email', $email);
        $user = $this->db->get(db_prefix() . 'contacts')->row();

        if ($user) {

            return $user->new_pass_key;
//            $new_pass_key = app_generate_hash();
//            $this->db->where('id', $user->id);
//            $this->db->update(db_prefix() . 'contacts', [
//                'new_pass_key'           => $new_pass_key,
//                'new_pass_key_requested' => date('Y-m-d H:i:s'),
//            ]);
//            if ($this->db->affected_rows() > 0) {
//                return $new_pass_key;
//            }
//
//            return false;
        }

        return false;
    }


}

